//
//  DataProtectionViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 21.02.23.
//

import UIKit

class DataProtectionViewController : UIViewController {
    
    @IBOutlet var dataProtectionView: UIView!
    
    
    @IBOutlet var dataProtectionScrollView: UIView!
    
    @IBOutlet var finalLabel: UILabel!
    @IBOutlet var dataProtectionHeaderLabel: UILabel!
    @IBOutlet var dataProtectionDetailsLabel: UILabel!
    
    @IBOutlet var textFontSizeSlider: UISlider!
    
    @IBOutlet var IntroductionAndOverviewHeaderLabel: UILabel!
    
    @IBOutlet var IntroductionAndOverviewLabel: UILabel!
    
    var textArrayIntroductionAndOverviewLabel = [String]()
    var fontArrayIntroductionAndOverviewLabel = [UIFont]()
    var colorArrayIntroductionAndOverviewLabel = [UIColor]()
    
    
    @IBOutlet var ApplicationAreaHeaderLabel: UILabel!
    
    @IBOutlet var ApplicationAreaDetailsLabel: UILabel!
    
    var textArrayApplicationAreaDetailsLabel = [String]()
    var fontArrayApplicationAreaDetailsLabel = [UIFont]()
    var colorArrayApplicationAreaDetailsLabel = [UIColor]()
    
    /*Legal Bases*/
    @IBOutlet var legalBasesHeaderLabel: UILabel!
    
    @IBOutlet var legalBasesDetailsLabel: UILabel!
    
    var textArray_legalBasesDetailsLabel = [String]()
    var fontArray_legalBasesDetailsLabel = [UIFont]()
    var colorArray_legalBasesDetailsLabel = [UIColor]()
    
    /*Contact Details*/
    @IBOutlet var contactDetailsHeaderLabel: UILabel!
    
    @IBOutlet var contactDetailsDetailsLabel: UILabel!
    
    var textArray_contactDetailsDetailsLabel = [String]()
    var fontArray_contactDetailsDetailsLabel = [UIFont]()
    var colorArray_contactDetailsDetailsLabel = [UIColor]()
    
    /*Data Storage*/
    @IBOutlet var dataStorageHeaderLabel: UILabel!
    
    @IBOutlet var dataStorageDetailsLabel: UILabel!
    
    var textArray_dataStorageDetailsLabel = [String]()
    var fontArray_dataStorageDetailsLabel = [UIFont]()
    var colorArray_dataStorageDetailsLabel = [UIColor]()
    
    
    /*Rights DSGVO*/
    @IBOutlet var rightsDSGVOHeaderLabel: UILabel!
    
    @IBOutlet var rightsDSGVODetailsLabel: UILabel!
    
    var textArray_rightsDSGVODetailsLabel = [String]()
    var fontArray_rightsDSGVODetailsLabel = [UIFont]()
    var colorArray_rightsDSGVODetailsLabel = [UIColor]()
    
    
    /*North Rhine-Westphalia Data Protection Authority*/
    @IBOutlet var dataProtectionContactHeaderLabel: UILabel!
    
    @IBOutlet var dataProtectionContactDetailsLabel: UILabel!
    
    var textArray_dataProtectionContactDetailsLabel = [String]()
    var fontArray_dataProtectionContactDetailsLabel = [UIFont]()
    var colorArray_dataProtectionContactDetailsLabel = [UIColor]()
    
    
    /*Customer Data*/
    @IBOutlet var customerDataHeaderLabel: UILabel!
    
    @IBOutlet var customerDataDetailsLabel: UILabel!
    
    var textArray_customerDataDetailsLabel = [String]()
    var fontArray_customerDataDetailsLabel = [UIFont]()
    var colorArray_customerDataDetailsLabel = [UIColor]()
    
    
    /*What Customer Data?*/
    @IBOutlet var customerDataWhatHeaderLabel: UILabel!
    
    @IBOutlet var customerDataWhatDetailsLabel: UILabel!
    
    var textArray_customerDataWhatDetailsLabel = [String]()
    var fontArray_customerDataWhatDetailsLabel = [UIFont]()
    var colorArray_customerDataWhatDetailsLabel = [UIColor]()
    
    
    /*Why Customer Data?*/
    @IBOutlet var customerDataWhyHeaderLabel: UILabel!
    
    @IBOutlet var customerDataWhyDetailsLabel: UILabel!
    
    var textArray_customerDataWhyDetailsLabel = [String]()
    var fontArray_customerDataWhyDetailsLabel = [UIFont]()
    var colorArray_customerDataWhyDetailsLabel = [UIColor]()
    
    
    /*Processed Data*/
    @IBOutlet var processedDataHeaderLabel: UILabel!
    
    @IBOutlet var processedDataDetailsLabel: UILabel!
    
    var textArray_processedDataDetailsLabel = [String]()
    var fontArray_processedDataDetailsLabel = [UIFont]()
    var colorArray_processedDataDetailsLabel = [UIColor]()
    
    
    /*Data Location*/
    @IBOutlet var dataLocationHeaderLabel: UILabel!
    
    @IBOutlet var dataLocationDetailsLabel: UILabel!
    
    var textArray_dataLocationDetailsLabel = [String]()
    var fontArray_dataLocationDetailsLabel = [UIFont]()
    var colorArray_dataLocationDetailsLabel = [UIColor]()
    
    
    /*Data Storage Duration*/
    @IBOutlet var dataStorageDurationHeaderLabel: UILabel!
    
    @IBOutlet var dataStorageDurationDetailsLabel: UILabel!
    
    var textArray_dataStorageDurationDetailsLabel = [String]()
    var fontArray_dataStorageDurationDetailsLabel = [UIFont]()
    var colorArray_dataStorageDurationDetailsLabel = [UIColor]()
    
    
    /*Data Legal Bases*/
    @IBOutlet var dataLegalBasesHeaderLabel: UILabel!
    
    @IBOutlet var dataLegalBasesDetailsLabel: UILabel!
    
    var textArray_dataLegalBasesDetailsLabel = [String]()
    var fontArray_dataLegalBasesDetailsLabel = [UIFont]()
    var colorArray_dataLegalBasesDetailsLabel = [UIColor]()
    
    
    /*Registration*/
    @IBOutlet var registrationHeaderLabel: UILabel!
    
    @IBOutlet var registrationDetailsLabel: UILabel!
    
    var textArray_registrationDetailsLabel = [String]()
    var fontArray_registrationDetailsLabel = [UIFont]()
    var colorArray_registrationDetailsLabel = [UIColor]()
    
    
    /*What is a Registration?*/
    @IBOutlet var registrationWhatHeaderLabel: UILabel!
    
    @IBOutlet var registrationWhatDetailsLabel: UILabel!
    
    var textArray_registrationWhatDetailsLabel = [String]()
    var fontArray_registrationWhatDetailsLabel = [UIFont]()
    var colorArray_registrationWhatDetailsLabel = [UIColor]()
    
    
    /*Why Processing Data?*/
    @IBOutlet var dataProcessingWhyHeaderLabel: UILabel!
    
    @IBOutlet var dataProcessingWhyDetailsLabel: UILabel!
    
    var textArray_dataProcessingWhyDetailsLabel = [String]()
    var fontArray_dataProcessingWhyDetailsLabel = [UIFont]()
    var colorArray_dataProcessingWhyDetailsLabel = [UIColor]()
    
    
    /*Storage Duration*/
    @IBOutlet var storageDurationHeaderLabel: UILabel!
    
    @IBOutlet var storageDurationDetailsLabel: UILabel!
    
    var textArray_storageDurationDetailsLabel = [String]()
    var fontArray_storageDurationDetailsLabel = [UIFont]()
    var colorArray_storageDurationDetailsLabel = [UIColor]()
    
    
    /*Right of objection*/
    @IBOutlet var rightofObjectionHeaderLabel: UILabel!
    
    @IBOutlet var rightofObjectionDetailsLabel: UILabel!
    
    var textArray_rightofObjectionDetailsLabel = [String]()
    var fontArray_rightofObjectionDetailsLabel = [UIFont]()
    var colorArray_rightofObjectionDetailsLabel = [UIColor]()
    
    
    /*Legal Bases*/
    @IBOutlet var registrationLegalBasesHeaderLabel: UILabel!
    
    @IBOutlet var registrationLegalBasesDetailsLabel: UILabel!
    
    var textArray_registrationLegalBasesDetailsLabel = [String]()
    var fontArray_registrationLegalBasesDetailsLabel = [UIFont]()
    var colorArray_registrationLegalBasesDetailsLabel = [UIColor]()
    
    
    /*Registration Pseudonym*/
    @IBOutlet var registrationPseudonymHeaderLabel: UILabel!
    
    @IBOutlet var registrationPseudonymDetailsLabel: UILabel!
    
    var textArray_registrationPseudonymDetailsLabel = [String]()
    var fontArray_registrationPseudonymDetailsLabel = [UIFont]()
    var colorArray_registrationPseudonymDetailsLabel = [UIColor]()
    
    /*Storage IP Address*/
    @IBOutlet var storageIPAddressHeaderLabel: UILabel!
    
    @IBOutlet var storageIPAddressDetailsLabel: UILabel!
    
    var textArray_storageIPAddressDetailsLabel = [String]()
    var fontArray_storageIPAddressDetailsLabel = [UIFont]()
    var colorArray_storageIPAddressDetailsLabel = [UIColor]()
    
    
    /*Final Words*/
    @IBOutlet var finalWordsHeaderLabel: UILabel!
    
    @IBOutlet var finalWordsDetailsLabel: UILabel!
    
    var textArray_finalWordsDetailsLabel = [String]()
    var fontArray_finalWordsDetailsLabel = [UIFont]()
    var colorArray_finalWordsDetailsLabel = [UIColor]()
 
    
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        //setGradientBackground()
        //dataProtectionView.translatesAutoresizingMaskIntoConstraints = false
        //dataProtectionView.heightAnchor.constraint(equalToConstant: 9000).isActive = true
        
        textFontSizeSlider.minimumValue = 0.5
        //textFontSizeSlider.minimumValue = 25
        
        //textFontSizeSlider.setValue(15.0, animated: true)
        
        textFontSizeSlider.minimumValueImage = UIImage(named: "A_FontSmall")
        textFontSizeSlider.maximumValueImage = UIImage(named: "A_FontBig")
        
        
        
        
        
        dataProtectionHeaderLabel.text = "Datenschutzerklärung von HCS Studies"
        dataProtectionHeaderLabel.font = Fonts.heavyFontWithSize(size: 15)
        
        IntroductionAndOverviewHeaderLabel.text = "Einleitung und Überblick"
        IntroductionAndOverviewHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        

        
        /*
        textArray.append("I accept")
        textArray.append("the general conditions")
        textArray.append("and")
        textArray.append("the cancellation policies")
         */

        textArrayIntroductionAndOverviewLabel.append("Wir haben diese Datenschutzerklärung (Fassung 21.06.2023) verfasst, um Ihnen gemäß den Vorgaben der")
        textArrayIntroductionAndOverviewLabel.append("Datenschutzgrundverordnung (EU) 2016/679")
        textArrayIntroductionAndOverviewLabel.append("und anwendbare nationalen Gesetzen zu erklären, welche personenbezogenen Daten (kurz Daten) wir als Verantwortliche – und die von uns beauftragten Auftragsverarbeiter (z.B. Provider) – verarbeiten, zukünftig verarbeiten werden und welche rechtmäßigen Möglichkeiten Sie haben. Die verwendeten Begriffe sind geschlechtsneutral zu verstehen.")
        textArrayIntroductionAndOverviewLabel.append("\nKurz gesagt:")
        textArrayIntroductionAndOverviewLabel.append("Wir informieren Sie umfassend über Daten, die wir über Sie verarbeiten.")
        textArrayIntroductionAndOverviewLabel.append("\n\nDatenschutzerklärungen klingen für gewöhnlich sehr technisch und verwenden juristische Fachbegriffe. Diese Datenschutzerklärung soll Ihnen hingegen die wichtigsten Dinge so einfach und transparent wie möglich beschreiben. Soweit es der Transparenz förderlich ist, werden technische")
        textArrayIntroductionAndOverviewLabel.append("Begriffe leserfreundlich erklärt")
        textArrayIntroductionAndOverviewLabel.append("und Links zu weiterführenden Informationen geboten. Wir informieren damit in klarer und einfacher Sprache, dass wir im Rahmen unserer wissenschaftlichen Arbeit nur dann personenbezogene Daten verarbeiten, wenn eine entsprechende gesetzliche Grundlage gegeben ist.\nWenn trotzdem Fragen bleiben, möchten wir Sie bitten, sich an die unten bzw. im Impressum genannte verantwortliche Stelle zu wenden und den vorhandenen Links zu folgen. Unsere Kontaktdaten finden Sie selbstverständlich auch im Impressum.")
        
        fontArrayIntroductionAndOverviewLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.lightFontWithSize(size: 13))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.mediumFontWithSize(size: 13))

        colorArrayIntroductionAndOverviewLabel.append(Colors.greyColor)
        colorArrayIntroductionAndOverviewLabel.append(Colors.carmine)
        colorArrayIntroductionAndOverviewLabel.append(Colors.greyColor)
        colorArrayIntroductionAndOverviewLabel.append(Colors.greyColor)
        colorArrayIntroductionAndOverviewLabel.append(Colors.greyColor)
        colorArrayIntroductionAndOverviewLabel.append(Colors.greyColor)
        colorArrayIntroductionAndOverviewLabel.append(Colors.greyColor)
        colorArrayIntroductionAndOverviewLabel.append(Colors.greyColor)
        
        
        self.IntroductionAndOverviewLabel.attributedText = getAttributedString(arrayText: textArrayIntroductionAndOverviewLabel, arrayColors: colorArrayIntroductionAndOverviewLabel, arrayFonts: fontArrayIntroductionAndOverviewLabel)
        self.IntroductionAndOverviewLabel.isUserInteractionEnabled = true
        let tapgesture = UITapGestureRecognizer(target: self, action: #selector(tappedOnLabel(_ :)))
        tapgesture.numberOfTapsRequired = 1
        self.IntroductionAndOverviewLabel.addGestureRecognizer(tapgesture)
        
        ApplicationAreaHeaderLabel.text = "Anwendungsbereich"
        ApplicationAreaHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArrayApplicationAreaDetailsLabel.append("Diese Datenschutzerklärung gilt für alle von uns im Unternehmen verarbeiteten personenbezogenen Daten und für alle personenbezogenen Daten, die von uns beauftragte Firmen (Auftragsverarbeiter) verarbeiten. Mit personenbezogenen Daten meinen wir Informationen im Sinne des Art. 4 Nr. 1 DSGVO wie zum Beispiel Name, E-Mail-Adresse und postalische Anschrift einer Person. Die Verarbeitung personenbezogener Daten sorgt dafür, dass wir unsere Dienstleistungen (Studien) und Produkte anbieten können, sei es online oder offline. Der Anwendungsbereich dieser Datenschutzerklärung umfasst:\n  • mobile Apps für Smartphones und andere Geräte")
        textArrayApplicationAreaDetailsLabel.append("\nKurz gesagt:")
        textArrayApplicationAreaDetailsLabel.append("Die Datenschutzerklärung gilt für alle Bereiche, in denen personenbezogene Daten im wissenschaftlichen Bereich über die genannten Kanäle strukturiert und verarbeitet werden.")
        fontArrayApplicationAreaDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArrayApplicationAreaDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArrayApplicationAreaDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArrayApplicationAreaDetailsLabel.append(Colors.greyColor)
        colorArrayApplicationAreaDetailsLabel.append(Colors.greyColor)
        colorArrayApplicationAreaDetailsLabel.append(Colors.greyColor)
        
        self.ApplicationAreaDetailsLabel.attributedText = getAttributedString(arrayText: textArrayApplicationAreaDetailsLabel, arrayColors: colorArrayApplicationAreaDetailsLabel, arrayFonts: fontArrayApplicationAreaDetailsLabel)
        //ApplicationAreaDetailsLabel.setNeedsLayout()
        //ApplicationAreaDetailsLabel.layoutIfNeeded()
        
        
        /*Legal Bases*/
        legalBasesHeaderLabel.text = "Rechtsgrundlagen"
        legalBasesHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_legalBasesDetailsLabel.append("In der folgenden Datenschutzerklärung geben wir Ihnen transparente Informationen zu den rechtlichen Grundsätzen und Vorschriften, also den Rechtsgrundlagen der Datenschutz-Grundverordnung, die uns ermöglichen, personenbezogene Daten zu verarbeiten.\nWas das EU-Recht betrifft, beziehen wir uns auf die VERORDNUNG (EU) 2016/679 DES EUROPÄISCHEN PARLAMENTS UND DES RATES vom 27. April 2016. Diese Datenschutz-Grundverordnung der EU können Sie selbstverständlich online auf EUR-Lex, dem Zugang zum EU-Recht, unter")
        textArray_legalBasesDetailsLabel.append("https://eur-lex.europa.eu/legal-content/DE/ALL/?uri=celex%3A32016R0679")
        textArray_legalBasesDetailsLabel.append("nachlesen.\n\nWir verarbeiten Ihre Daten nur, wenn mindestens eine der folgenden Bedingungen zutrifft:")
        textArray_legalBasesDetailsLabel.append("\n  1. Einwilligung")
        textArray_legalBasesDetailsLabel.append("(Artikel 6 Absatz 1 lit. a DSGVO): Sie haben uns Ihre Einwilligung gegeben, Daten zu einem bestimmten Zweck zu verarbeiten. Ein Beispiel wäre die Speicherung Ihrer eingegebenen Daten eines Kontaktformulars.")
        textArray_legalBasesDetailsLabel.append("\n  2. Vertrag")
        textArray_legalBasesDetailsLabel.append("(Artikel 6 Absatz 1 lit. b DSGVO): Um einen Vertrag oder vorvertragliche Verpflichtungen mit Ihnen zu erfüllen, verarbeiten wir Ihre Daten. Wenn wir zum Beispiel einen Vertrag mit Ihnen abschließen, benötigen wir vorab personenbezogene Informationen.")
        textArray_legalBasesDetailsLabel.append("\n  3. Rechtliche Verpflichtung")
        textArray_legalBasesDetailsLabel.append("(Artikel 6 Absatz 1 lit. c DSGVO): Wenn wir einer rechtlichen Verpflichtung unterliegen, verarbeiten wir Ihre Daten.")
        textArray_legalBasesDetailsLabel.append("\n  4. Berechtigte Interessen")
        textArray_legalBasesDetailsLabel.append("(Artikel 6 Absatz 1 lit. f DSGVO): Im Falle berechtigter Interessen, die Ihre Grundrechte nicht einschränken, behalten wir uns die Verarbeitung personenbezogener Daten vor. Wir müssen zum Beispiel gewisse Daten verarbeiten, um unsere App sicher betreiben zu können. Diese Verarbeitung ist somit ein berechtigtes Interesse.\n\nZusätzlich zu der EU-Verordnung gelten auch noch nationale Gesetze:")
        textArray_legalBasesDetailsLabel.append("\n  • In")
        textArray_legalBasesDetailsLabel.append("Deutschland")
        textArray_legalBasesDetailsLabel.append("gilt das")
        textArray_legalBasesDetailsLabel.append("Bundesdatenschutzgesetz,")
        textArray_legalBasesDetailsLabel.append("kurz")
        textArray_legalBasesDetailsLabel.append("BDSG.")
        textArray_legalBasesDetailsLabel.append("\n\nSofern weitere regionale oder nationale Gesetze zur Anwendung kommen, informieren wir Sie in den folgenden Abschnitten darüber.")
        
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.lightFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.carmine)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        colorArray_legalBasesDetailsLabel.append(Colors.greyColor)
        
        self.legalBasesDetailsLabel.attributedText = getAttributedString(arrayText: textArray_legalBasesDetailsLabel, arrayColors: colorArray_legalBasesDetailsLabel, arrayFonts: fontArray_legalBasesDetailsLabel)
        self.legalBasesDetailsLabel.isUserInteractionEnabled = true
        let tapgesture_LegalBases = UITapGestureRecognizer(target: self, action: #selector(tappedOnLabel_LegalBases(_ :)))
        tapgesture_LegalBases.numberOfTapsRequired = 1
        self.legalBasesDetailsLabel.addGestureRecognizer(tapgesture_LegalBases)
        
        
        /*Contact Details*/
        contactDetailsHeaderLabel.text = "Kontaktdaten des Verantwortlichen"
        contactDetailsHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_contactDetailsDetailsLabel.append("Sollten Sie Fragen zum Datenschutz oder zur Verarbeitung personenbezogener Daten haben, finden Sie nachfolgend die Kontaktdaten der verantwortlichen Person bzw. Stelle:\n  • Mobile Security Group (MobSec), Ruhr-Universität Bochum\n  • Marvin Kowalewski\n  • mobsec-studies@rub.de")
        
        fontArray_contactDetailsDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_contactDetailsDetailsLabel.append(Colors.greyColor)
        
        self.contactDetailsDetailsLabel.attributedText = getAttributedString(arrayText: textArray_contactDetailsDetailsLabel, arrayColors: colorArray_contactDetailsDetailsLabel, arrayFonts: fontArray_contactDetailsDetailsLabel)
        
        
        /*Data Storage*/
        dataStorageHeaderLabel.text = "Speicherdauer"
        dataStorageHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_dataStorageDetailsLabel.append("Dass wir personenbezogene Daten nur so lange speichern, wie es für die Bereitstellung unserer Dienstleistungen (Studien) und Produkte unbedingt notwendig ist, gilt als generelles Kriterium bei uns. Das bedeutet, dass wir personenbezogene Daten löschen, sobald der Grund für die Datenverarbeitung nicht mehr vorhanden ist. In einigen Fällen sind wir gesetzlich dazu verpflichtet, bestimmte Daten auch nach dem Wegfall des ursprünglichen Zwecks zu speichern.\n\nSollten Sie die Löschung Ihrer Daten wünschen oder die Einwilligung zur Datenverarbeitung widerrufen, werden die Daten so rasch wie möglich und soweit keine Pflicht zur Speicherung besteht, löschen.\n\nÜber die konkrete Dauer der jeweiligen Datenverarbeitung informieren wir Sie weiter unten, sofern wir weitere Informationen dazu haben.")
        
        fontArray_dataStorageDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_dataStorageDetailsLabel.append(Colors.greyColor)
        
        self.dataStorageDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataStorageDetailsLabel, arrayColors: colorArray_dataStorageDetailsLabel, arrayFonts: fontArray_dataStorageDetailsLabel)
        
        
        /*Rights DSGVO*/
        rightsDSGVOHeaderLabel.text = "Rechte laut Datenschutz-Grundverordnung"
        rightsDSGVOHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_rightsDSGVODetailsLabel.append("Gemäß Artikel 13, 14 DSGVO informieren wir Sie über die folgenden Rechte, die Ihnen zustehen, damit es zu einer fairen und transparenten Verarbeitung von Daten kommt:\n  • Sie haben laut Artikel 15 DSGVO ein Auskunftsrecht darüber, ob wir Daten von Ihnen verarbeiten. Sollte das zutreffen, haben Sie Rech darauf eine Kopie der Daten zu erhalten und die folgenden Informationen zu erfahren:\nzu welchem Zweck wir die Verarbeitung durchführen;\n    - die Kategorien, also die Arten von Daten, die verarbeitet werden;\n    - wer diese Daten erhält und wenn die Daten an Drittländer übermittelt werden, wie die Sicherheit garantiert werden kann;\n    - wie lange die Daten gespeichert werden;\n    - das Bestehen des Rechts auf Berichtigung, Löschung oder Einschränkung der Verarbeitung und dem Widerspruchsrecht gegen die Verarbeitung;\n    - dass Sie sich bei einer Aufsichtsbehörde beschweren können (Links zu diesen Behörden finden Sie weiter unten);\n    - die Herkunft der Daten, wenn wir sie nicht bei Ihnen erhoben haben;\n    - ob Profiling durchgeführt wird, ob also Daten automatisch ausgewertet werden, um zu einem persönlichen Profil von Ihnen zu gelangen.\n  • Sie haben laut Artikel 16 DSGVO ein Recht auf Berichtigung der Daten, was bedeutet, dass wir Daten richtig stellen müssen, falls Sie Fehler finden.\n  • Sie haben laut Artikel 17 DSGVO ein Recht auf Löschung („Recht auf Vergessenwerden“), was konkret bedeutet, dass Sie die Löschung Ihrer Daten verlangen dürfen.\n  • Sie haben laut Artikel 18 DSGVO ein Recht auf Einschränkung der Verarbeitung, was bedeutet, dass wir die Daten nur mehr speichern dürfen aber nicht weiter verwenden.\n  • Sie haben laut Artikel 20 DSGVO ein Recht auf Datenübertragbarkeit, was bedeutet, dass wir Ihnen auf Anfrage Ihre Daten in einem gängigen Format zur Verfügung stellen.\n    - Wenn die Verarbeitung Ihrer Daten auf Artikel 6 Abs. 1 lit. e (öffentliches Interesse, Ausübung öffentlicher Gewalt) oder Artikel 6 Abs. 1 lit. f (berechtigtes Interesse) basiert, können Sie gegen die Verarbeitung Widerspruch einlegen. Wir prüfen danach so rasch wie möglich, ob wir diesen Widerspruch rechtlich nachkommen können.\n    - Werden Daten verwendet, um Direktwerbung zu betreiben, können Sie jederzeit gegen diese Art der Datenverarbeitung widersprechen. Wir dürfen Ihre Daten danach nicht mehr für Direktmarketing verwenden.\n    - Werden Daten verwendet, um Profiling zu betreiben, können Sie jederzeit gegen diese Art der Datenverarbeitung widersprechen. Wir dürfen Ihre Daten danach nicht mehr für Profiling verwenden.\n  • Sie haben laut Artikel 22 DSGVO unter Umständen das Recht, nicht einer ausschließlich auf einer automatisierten Verarbeitung (zum Beispiel Profiling) beruhenden Entscheidung unterworfen zu werden.\n  • Sie haben laut Artikel 77 DSGVO das Recht auf Beschwerde. Das heißt, Sie können sich jederzeit bei der Datenschutzbehörde beschweren, wenn Sie der Meinung sind, dass die Datenverarbeitung von personenbezogenen Daten gegen die DSGVO verstößt.")
        textArray_rightsDSGVODetailsLabel.append("\nKurz gesagt:")
        textArray_rightsDSGVODetailsLabel.append("Sie haben Rechte – zögern Sie nicht, die oben gelistete verantwortliche Stelle bei uns zu kontaktieren!\n\nWenn Sie glauben, dass die Verarbeitung Ihrer Daten gegen das Datenschutzrecht verstößt oder Ihre datenschutzrechtlichen Ansprüche in sonst einer Weise verletzt worden sind, können Sie sich bei der Aufsichtsbehörde beschweren. In Deutschland gibt es für jedes Bundesland einen Datenschutzbeauftragten. Für nähere Informationen können Sie sich an die")
        textArray_rightsDSGVODetailsLabel.append("Bundesbeauftragte für den Datenschutz und die Informationsfreiheit (BfDI)")
        textArray_rightsDSGVODetailsLabel.append("wenden. Für unsere App ist die folgende lokale Datenschutzbehörde zuständig:")
        
        fontArray_rightsDSGVODetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_rightsDSGVODetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_rightsDSGVODetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_rightsDSGVODetailsLabel.append(Fonts.lightFontWithSize(size: 13))
        fontArray_rightsDSGVODetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_rightsDSGVODetailsLabel.append(Colors.greyColor)
        colorArray_rightsDSGVODetailsLabel.append(Colors.greyColor)
        colorArray_rightsDSGVODetailsLabel.append(Colors.greyColor)
        colorArray_rightsDSGVODetailsLabel.append(Colors.carmine)
        colorArray_rightsDSGVODetailsLabel.append(Colors.greyColor)
        
        self.rightsDSGVODetailsLabel.attributedText = getAttributedString(arrayText: textArray_rightsDSGVODetailsLabel, arrayColors: colorArray_rightsDSGVODetailsLabel, arrayFonts: fontArray_rightsDSGVODetailsLabel)
        self.rightsDSGVODetailsLabel.isUserInteractionEnabled = true
        let tapgesture_rightsDSGVO = UITapGestureRecognizer(target: self, action: #selector(tappedOnLabel_RightsDSGVO(_ :)))
        tapgesture_rightsDSGVO.numberOfTapsRequired = 1
        self.rightsDSGVODetailsLabel.addGestureRecognizer(tapgesture_rightsDSGVO)
        
        
        /*North Rhine-Westphalia Data Protection Authority*/
        dataProtectionContactHeaderLabel.text = "Nordrhein-Westfalen Datenschutzbehörde"
        dataProtectionContactHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_dataProtectionContactDetailsLabel.append("Landesbeauftragte für Datenschutz:")
        textArray_dataProtectionContactDetailsLabel.append("Bettina Gayk")
        textArray_dataProtectionContactDetailsLabel.append("\nAdresse:")
        textArray_dataProtectionContactDetailsLabel.append("Kavalleriestraße 2-4, 40213 Düsseldorf")
        textArray_dataProtectionContactDetailsLabel.append("\nTelefonnr.:")
        textArray_dataProtectionContactDetailsLabel.append("0211/38424-0")
        textArray_dataProtectionContactDetailsLabel.append("\nE-Mail:")
        textArray_dataProtectionContactDetailsLabel.append("poststelle@Idi.nrw.de")
        textArray_dataProtectionContactDetailsLabel.append("\nWebseite:")
        textArray_dataProtectionContactDetailsLabel.append("https://www.ldi.nrw.de/")
        
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.lightFontWithSize(size: 13))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.lightFontWithSize(size: 13))
        
        colorArray_dataProtectionContactDetailsLabel.append(Colors.greyColor)
        colorArray_dataProtectionContactDetailsLabel.append(Colors.greyColor)
        colorArray_dataProtectionContactDetailsLabel.append(Colors.greyColor)
        colorArray_dataProtectionContactDetailsLabel.append(Colors.greyColor)
        colorArray_dataProtectionContactDetailsLabel.append(Colors.greyColor)
        colorArray_dataProtectionContactDetailsLabel.append(Colors.greyColor)
        colorArray_dataProtectionContactDetailsLabel.append(Colors.greyColor)
        colorArray_dataProtectionContactDetailsLabel.append(Colors.carmine)
        colorArray_dataProtectionContactDetailsLabel.append(Colors.greyColor)
        colorArray_dataProtectionContactDetailsLabel.append(Colors.carmine)
        
        self.dataProtectionContactDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataProtectionContactDetailsLabel, arrayColors: colorArray_dataProtectionContactDetailsLabel, arrayFonts: fontArray_dataProtectionContactDetailsLabel)
        self.dataProtectionContactDetailsLabel.isUserInteractionEnabled = true
        let tapgesture_dataProtectionContactDetails = UITapGestureRecognizer(target: self, action: #selector(tappedOnLabel_DataProtectionContactDetails(_ :)))
        tapgesture_dataProtectionContactDetails.numberOfTapsRequired = 1
        self.dataProtectionContactDetailsLabel.addGestureRecognizer(tapgesture_dataProtectionContactDetails)
        
        
        /*Customer Data*/
        customerDataHeaderLabel.text = "Kundendaten (Teilnehmerdaten)"
        customerDataHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_customerDataDetailsLabel.append("Kundendaten Zusammenfassung")
        textArray_customerDataDetailsLabel.append("\nBetroffene: Teilnehmende an Studien Zweck: \nErbringung der vertraglich oder vorvertraglich vereinbarten Leistungen einschließlich zugehöriger Kommunikation \nVerarbeitete Daten: Name, E-Mail-Adresse, IP-Adresse \nSpeicherdauer: Die Daten werden gelöscht, sobald Sie zur Erbringung unserer geschäftlichen Zwecke nicht mehr erforderlich sind und es keine gesetzliche Aufbewahrungspflicht gibt. \nRechtsgrundlagen: Berechtigtes Interesse (Art. 6 Abs. 1 lit. f DSGVO), Vertrag (Art. 6 Abs. 1 lit. b DSGVO)")
        
        fontArray_customerDataDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_customerDataDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_customerDataDetailsLabel.append(Colors.greyColor)
        colorArray_customerDataDetailsLabel.append(Colors.greyColor)
        
        self.customerDataDetailsLabel.attributedText = getAttributedString(arrayText: textArray_customerDataDetailsLabel, arrayColors: colorArray_customerDataDetailsLabel, arrayFonts: fontArray_customerDataDetailsLabel)
        
        
        /*What Customer Data?*/
        customerDataWhatHeaderLabel.text = "Was sind Kundendaten (Teilnehmerdaten)?"
        customerDataWhatHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_customerDataWhatDetailsLabel.append("Damit wir unseren Service (Studienteilnahme) bzw. unsere vertraglichen Leistungen anbieten können, verarbeiten wir auch Daten unserer Kunden. Unter diesen Daten befinden sich immer auch personenbezogene Daten. Unter Kundendaten versteht man alle Informationen, die auf Basis einer vertraglichen oder vorvertraglichen Zusammenarbeit verarbeitet werden, um die angebotenen Leistungen erbringen zu können. Kundendaten sind also alle gesammelten Informationen, die wir über unsere Kunden erheben und verarbeiten.")
        
        fontArray_customerDataWhatDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_customerDataWhatDetailsLabel.append(Colors.greyColor)
        
        self.customerDataWhatDetailsLabel.attributedText = getAttributedString(arrayText: textArray_customerDataWhatDetailsLabel, arrayColors: colorArray_customerDataWhatDetailsLabel, arrayFonts: fontArray_customerDataWhatDetailsLabel)
        
        /*What Customer Data?*/
        customerDataWhyHeaderLabel.text = "Warum verarbeiten wir Kundendaten (Teilnehmerdaten)?"
        customerDataWhyHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_customerDataWhyDetailsLabel.append("Es gibt viele Gründe, warum wir Kundendaten sammeln und verarbeiten. Der wichtige ist, dass wir zur Bereitstellung unserer Services einfach verschiedene Daten benötigen. Manchmal reicht hier schon Ihre E-Mail-Adresse, doch wenn Sie etwa eine Dienstleistung nutzen (Studie durchführen), benötigen wir zum Teil auch Daten wie beispielsweise Name oder E-Mail-Adresse.")
        
        fontArray_customerDataWhyDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_customerDataWhyDetailsLabel.append(Colors.greyColor)
        
        self.customerDataWhyDetailsLabel.attributedText = getAttributedString(arrayText: textArray_customerDataWhyDetailsLabel, arrayColors: colorArray_customerDataWhyDetailsLabel, arrayFonts: fontArray_customerDataWhyDetailsLabel)
        
        
        /*Processed Data*/
        processedDataHeaderLabel.text = "Welche Daten werden verarbeitet?"
        processedDataHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_processedDataDetailsLabel.append("Welche Daten genau gespeichert werden, kann an dieser Stelle nur anhand Kategorien wiedergegeben werden. Das hängt nämlich stehts davon ab, an welcher Studie Sie teilnehmen. In einigen Studien ist dem Nutzer lediglich ein Pseudonym zugewiesen.\n\nHier ist eine Liste möglicher Daten, die wir von Ihnen erhalten und verarbeiten:\n  • Name\n  • E-Mail-Adresse\n  • Telefonnummer\n  • Alter\n  • Bundesland\n  • Studienbezogene Daten, wie beispielsweise Antworten auf Fragen im Rahmen einer Studie\n  • Metadaten (Datum und Uhrzeit des Zugriffs, IP-Adresse des Nutzers)")

        fontArray_processedDataDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_processedDataDetailsLabel.append(Colors.greyColor)
        
        self.processedDataDetailsLabel.attributedText = getAttributedString(arrayText: textArray_processedDataDetailsLabel, arrayColors: colorArray_processedDataDetailsLabel, arrayFonts: fontArray_processedDataDetailsLabel)
        
        
        /*Data Location*/
        dataLocationHeaderLabel.text = "Wo werden die Daten gespeichert?"
        dataLocationHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_dataLocationDetailsLabel.append("Ihre Daten werden unter Inanspruchnahme folgender Dienstleistungen erhoben:\n  • Firestore Database (Google LLC)\n\nDabei handelt sich um eine dokumentenbasierte Datenbank, in der wir Ihre Daten speichern und verarbeiten. Ihre Daten werden am Standort Frankfurt, Deutschland verarbeitet.")

        fontArray_dataLocationDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_dataLocationDetailsLabel.append(Colors.greyColor)
        
        self.dataLocationDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataLocationDetailsLabel, arrayColors: colorArray_dataLocationDetailsLabel, arrayFonts: fontArray_dataLocationDetailsLabel)
        
        
        /*Data Storage Duration*/
        dataStorageDurationHeaderLabel.text = "Wie lange werden die Daten gespeichert?"
        dataStorageDurationHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_dataStorageDurationDetailsLabel.append("Sobald wir die Kundendaten (Teilnehmerdaten) zur Erfüllung unserer vertraglichen Pflichten und unserer Zwecke nicht mehr benötigen und die Daten auch nicht für mögliche Gewährleistungs- und Haftungspflichten nötig sind, löschen wir die entsprechenden Kundendaten. Das ist zum Beispiel der Fall, wenn wir Ihre Daten für Studienzwecke und wissenschaftliche Veröffentlichungen vollständig ausgewertet haben. Anschließend werden alle personenbezogenen Daten gelöscht und Ihre Antworten können nicht mehr Ihrer Person zugeordnet werden. Danach beträgt die Verjährungsfrist in der Regel 3 Jahre, wobei längere Fristen im Einzelfall möglich sind. Wir halten uns natürlich an die gesetzlichen Aufbewahrungspflichten. Ihre personenbezogenen Daten werden ganz sicher nicht an Dritte weitergegeben, wenn Sie dazu nicht explizit eine Einwilligung erteilt haben.")

        fontArray_dataStorageDurationDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_dataStorageDurationDetailsLabel.append(Colors.greyColor)
        
        self.dataStorageDurationDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataStorageDurationDetailsLabel, arrayColors: colorArray_dataStorageDurationDetailsLabel, arrayFonts: fontArray_dataStorageDurationDetailsLabel)
        
        
        /*Data Legal Bases*/
        dataLegalBasesHeaderLabel.text = "Rechtsgrundlage"
        dataLegalBasesHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_dataLegalBasesDetailsLabel.append("Rechtsgrundlagen für die Verarbeitung Ihrer Daten sind Art. 6 Abs. 1 lit. a DSGVO (Einwilligung), Art. 6 Abs. 1 lit. b DSGVO (Vertrag bzw. vorvertragliche Maßnahmen, Art. 6 Abs. 1 lit. f DSGVO (berechtigte Interessen). Für den Fall des Schutzes lebenswichtiger Interessen erfolgt die Datenverarbeitung gemäß Art9 6 Abs. 2 lit. c DSGVO.")

        fontArray_dataLegalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_dataLegalBasesDetailsLabel.append(Colors.greyColor)
        
        self.dataLegalBasesDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataLegalBasesDetailsLabel, arrayColors: colorArray_dataLegalBasesDetailsLabel, arrayFonts: fontArray_dataLegalBasesDetailsLabel)
        
        
        /*Registration*/
        registrationHeaderLabel.text = "Registrierung"
        registrationHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_registrationDetailsLabel.append("Registrierung Zusammenfassung")
        textArray_registrationDetailsLabel.append("Betroffene: Alle Personen, die sich für eine Studie registrieren, ein Konto anlegen und das Konto nutzen. \nVerarbeitete Daten: E-Mail-Adresse, Name, Passwort und weitere Daten, die im Zuge der Registrierung, Anmeldung und Kontonutzung erhoben werden. \nZweck: Zurverfügungstellung unserer Dienstleistungen, Kommunikation mit Kunden (Studienteilnehmenden) in Zusammenhang mit den Dienstleistungen. \nSpeicherdauer: Solange das Konto besteht und danach i.d.R. 3 Jahre. \nRechtsgrundlagen: Art. 6 Abs. 1 lit. b DSGVO (Vertrag), Art. 6 Abs. 1 lit. a DSGVO (Einwilligung), Art. 6 Abs. 1 lit. f DSGVO (Berechtigte Interessen)\n\nWenn Sie sich bei uns registrieren, kann es zur Verarbeitung personenbezogener Daten kommen, sofern Sie Daten mit Personenbezug eingeben bzw. Daten wie die IP-Adresse im Zuge der Verarbeitung erfasst werden. Was wir mit dem doch recht sperrigen Begriff „personenbezogene Daten“ meinen, können Sie weiter unten nachlesen.\n\nBitte geben Sie nur solche Daten ein, die wir für die Registrierung benötigen und für die Sie die Freigabe eines Dritten haben, falls Sie die Registrierung im Namen eines Dritten durchführen. Verwenden Sie nach Möglichkeit ein sicheres Passwort, welches Sie sonst nirgends verwenden und eine E-Mail-Adresse, die Sie regelmäßig abrufen.\n\nIm Folgenden informieren wir Sie über die genaue Art der Datenverarbeitung.")

        fontArray_registrationDetailsLabel.append(Fonts.heavyFontWithSize(size: 13))
        fontArray_registrationDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_registrationDetailsLabel.append(Colors.greyColor)
        colorArray_registrationDetailsLabel.append(Colors.greyColor)
        
        self.registrationDetailsLabel.attributedText = getAttributedString(arrayText: textArray_registrationDetailsLabel, arrayColors: colorArray_registrationDetailsLabel, arrayFonts: fontArray_registrationDetailsLabel)
        
        
        /*What is a Registration?*/
        registrationWhatHeaderLabel.text = "Was ist eine Registrierung?"
        registrationWhatHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_registrationWhatDetailsLabel.append("Bei einer Registrierung nehmen wir bestimmte Daten von Ihnen entgegen und ermöglichen es Ihnen sich später bei uns einfach online anzumelden und Ihr Konto bei uns zu verwenden. Ein Konto hat den Vorteil, dass Sie nicht jedes Mal alles erneut eingeben müssen. Spart Zeit, Mühe und verhindert letztendlich Fehler bei der Erbringung unserer Dienstleistungen.")

        fontArray_registrationWhatDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_registrationWhatDetailsLabel.append(Colors.greyColor)
        
        self.registrationWhatDetailsLabel.attributedText = getAttributedString(arrayText: textArray_registrationWhatDetailsLabel, arrayColors: colorArray_registrationWhatDetailsLabel, arrayFonts: fontArray_registrationWhatDetailsLabel)
        
        
        
        /*Why Processing Data?*/
        dataProcessingWhyHeaderLabel.text = "Warum verarbeiten wir personenbezogene Daten?"
        dataProcessingWhyHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_dataProcessingWhyDetailsLabel.append("Kurz gesagt verarbeiten wir personenbezogene Daten, um die Erstellung und Nutzung eines Kontos bei uns zu ermöglichen. Würden wir das nicht tun, müssten Sie jedes Mal alle Daten eingeben, auf eine Freigabe von uns warten und alles noch einmal eingeben.")

        fontArray_dataProcessingWhyDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_dataProcessingWhyDetailsLabel.append(Colors.greyColor)
        
        self.dataProcessingWhyDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataProcessingWhyDetailsLabel, arrayColors: colorArray_dataProcessingWhyDetailsLabel, arrayFonts: fontArray_dataProcessingWhyDetailsLabel)
        
        
        /*Storage Duration*/
        storageDurationHeaderLabel.text = "Speicherdauer"
        storageDurationHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_storageDurationDetailsLabel.append("Wir speichern die eingegebenen Daten zumindest für die Zeit, solange das mit den Daten verknüpfte Konto bei uns besteht und verwendet wird, solange vertragliche Verpflichtungen zwischen uns bestehen und, wenn der Vertrag endet, bis die jeweiligen Ansprüche daraus verjährt sind. Darüber hinaus speichern wir Ihre Daten solange und soweit wir gesetzlichen Verpflichtungen zur Speicherung unterliegen.\nDanach bewahren wir zum Vertrag gehörige Daten sowie relevante Unterlagen für die gesetzliche vorgeschriebene Dauer (i.d.R. einige Jahre) auf.")

        fontArray_storageDurationDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_storageDurationDetailsLabel.append(Colors.greyColor)
        
        self.storageDurationDetailsLabel.attributedText = getAttributedString(arrayText: textArray_storageDurationDetailsLabel, arrayColors: colorArray_storageDurationDetailsLabel, arrayFonts: fontArray_storageDurationDetailsLabel)
        
        
        /* Right of Objection*/
        rightofObjectionHeaderLabel.text = "Widerspruchsrecht"
        rightofObjectionHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_rightofObjectionDetailsLabel.append("Sie haben sich registriert, Daten eingegeben und möchten die Verarbeitung widerrufen? Kein Problem. Wie sie oben lesen können, bestehen die Rechte laut Datenschutz-Grundverordnung auch bei und nach der Registrierung, Anmeldung oder dem Konto bei uns.\nKontaktieren Sie den weiter oben stehenden Verantwortlichen für Datenschutz, um Ihre Rechte wahrzunehmen. Sollten Sie bereits ein Konto bei uns haben, können Sie Ihre Daten und Texte ganz einfach im Konto einsehen bzw. verwalten.")

        fontArray_rightofObjectionDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_rightofObjectionDetailsLabel.append(Colors.greyColor)
        
        self.rightofObjectionDetailsLabel.attributedText = getAttributedString(arrayText: textArray_rightofObjectionDetailsLabel, arrayColors: colorArray_rightofObjectionDetailsLabel, arrayFonts: fontArray_rightofObjectionDetailsLabel)
        
        
        /*Legal Bases*/
        registrationLegalBasesHeaderLabel.text = "Rechtsgrundlage"
        registrationLegalBasesHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_registrationLegalBasesDetailsLabel.append("Mit Durchführung des Registrierungsvorgangs treten Sie vorvertraglich an uns heran, um einen Nutzungsvertrag über unsere Plattform zu schließen. Sie investieren Zeit, um Daten einzugeben und sich zu registrieren und wir bieten Ihnen unsere Dienstleistungen nach Anmeldung in unserem System und die Einsicht in Ihr Kundenkonto. Außerdem kommen wir unseren vertraglichen Verpflichtungen nach. Schließlich müssen wir registrierte Nutzer bei wichtigen Änderungen per E-Mail auf dem laufenden halten. Damit trifft Art. 6 Abs. 1 lit. b DSGVO (Durchführung vorvertraglicher Maßnahmen, Erfüllung eines Vertrags) zu.\n\nGegebenenfalls holen wir darüber hinaus auch Ihre Einwilligung ein, z.B. wenn Sie freiwillig mehr als die unbedingt notwendigen Daten angeben. Art. 6 Abs. 1 lit. a DSGVO (Einwilligung) trifft somit zu.\n\nWir haben außerdem ein berechtigtes Interesse zu wissen, mit wem wir es zu tun haben, um in bestimmten Fällen in Kontakt zu treten. Außerdem müssen wir wissen wer unsere Dienstleistungen in Anspruch nimmt und ob sie so verwendet werden, wie es unsere Nutzungsbedingungen vorgeben, es trifft also Art. 6 Abs. 1 lit. f DSGVO (Berechtigtes Interesse) zu.")

        fontArray_registrationLegalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_registrationLegalBasesDetailsLabel.append(Colors.greyColor)
        
        self.registrationLegalBasesDetailsLabel.attributedText = getAttributedString(arrayText: textArray_registrationLegalBasesDetailsLabel, arrayColors: colorArray_registrationLegalBasesDetailsLabel, arrayFonts: fontArray_registrationLegalBasesDetailsLabel)
        
        
        /*Registration Pseudonym*/
        registrationPseudonymHeaderLabel.text = "Registrierung mit Pseudonymen"
        registrationPseudonymHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_registrationPseudonymDetailsLabel.append("Bei der Registrierung können Pseudonyme verwendet werden, das heißt Sie müssen sich bei uns nicht mit Ihrem richtigen Namen (Klarnamen) registrieren. Damit ist sichergestellt, dass Ihr Name nicht von uns verarbeitet werden kann.")

        fontArray_registrationPseudonymDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_registrationPseudonymDetailsLabel.append(Colors.greyColor)
        
        self.registrationPseudonymDetailsLabel.attributedText = getAttributedString(arrayText: textArray_registrationPseudonymDetailsLabel, arrayColors: colorArray_registrationPseudonymDetailsLabel, arrayFonts: fontArray_registrationPseudonymDetailsLabel)
        
        
        /*Storage IP Address*/
        storageIPAddressHeaderLabel.text = "Speicherung der IP-Adresse"
        storageIPAddressHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_storageIPAddressDetailsLabel.append("Im Zuge der Registrierung, Anmeldung und Kontonutzung speichern wir aus Sicherheitsgründen die IP-Adresse im Hintergrund, um die rechtmäßige Nutzung feststellen zu können.")

        fontArray_storageIPAddressDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_storageIPAddressDetailsLabel.append(Colors.greyColor)
        
        self.storageIPAddressDetailsLabel.attributedText = getAttributedString(arrayText: textArray_storageIPAddressDetailsLabel, arrayColors: colorArray_storageIPAddressDetailsLabel, arrayFonts: fontArray_storageIPAddressDetailsLabel)
        
        
        /*Final Words*/
        finalWordsHeaderLabel.text = "Schlusswort"
        finalWordsHeaderLabel.font = Fonts.heavyFontWithSize(size: 14)
        
        textArray_finalWordsDetailsLabel.append("Herzlichen Glückwunsch! Wenn Sie diese Zeilen lesen, haben Sie sich wirklich durch unsere gesamte Datenschutzerklärung „gekämpft“. Oder zumindest bis hier hin gescrollt. Wie Sie am Anfang unserer Datenschutzerklärung sehen, nehmen wir den Schutz Ihrer persönlichen Daten, alles andere als auf die leichte Schulter.\nUns ist es wichtig, Sie nach bestem Wissen und Gewissen über die Verarbeitung personenbezogener Daten zu informieren. Dabei wollen wir Ihnen aber nicht nur mitteilen, welche Daten verarbeitet werden, sondern auch die Beweggründe für die Verwendung diverser Daten näherbringen. In der Regel klingen Datenschutzerklärungen sehr technisch und juristisch. Da die meisten von Ihnen aber keine Webentwickler oder Juristen sind, wollen wir auch sprachlich einen anderen Weg gehen und den Sachverhalt in einfacher und klarer Sprache erklären. Immer ist dies natürlich aufgrund der Thematik nicht möglich.\nBei Fragen zum Thema Datenschutz zögern Sie bitte nicht, uns oder die verantwortliche Stelle zu kontaktieren.\n\nAlle Texte sind urheberrechtlich geschützt.\n\nQuelle: Für ein leichteres Verständnis teilweise erstellt mit dem")
        textArray_finalWordsDetailsLabel.append("Datenschutz Generator")
        textArray_finalWordsDetailsLabel.append("von AdSimple.")
        
        
        fontArray_finalWordsDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        fontArray_finalWordsDetailsLabel.append(Fonts.lightFontWithSize(size: 13))
        fontArray_finalWordsDetailsLabel.append(Fonts.mediumFontWithSize(size: 13))
        
        colorArray_finalWordsDetailsLabel.append(Colors.greyColor)
        colorArray_finalWordsDetailsLabel.append(Colors.carmine)
        colorArray_finalWordsDetailsLabel.append(Colors.greyColor)
        
        self.finalWordsDetailsLabel.attributedText = getAttributedString(arrayText: textArray_finalWordsDetailsLabel, arrayColors: colorArray_finalWordsDetailsLabel, arrayFonts: fontArray_finalWordsDetailsLabel)
        self.finalWordsDetailsLabel.isUserInteractionEnabled = true
        let tapgesture_tapgesture_finalWords = UITapGestureRecognizer(target: self, action: #selector(tappedOnLabel_finalWords(_ :)))
        tapgesture_tapgesture_finalWords.numberOfTapsRequired = 1
        self.finalWordsDetailsLabel.addGestureRecognizer(tapgesture_tapgesture_finalWords)
                
        //dataProtectionDetailsLabel.text = "\nDiese Datenschutzerklärung informiert Sie über die Art, den Umfang und die Zwecke der Verarbeitung (personenbezogener) Daten im Rahmen der Nutzung der HCS Studies App.\n\n\n1   Verantwortlicher\nVerantwortlicher im Sinne der Datenschutzgesetze ist die Mobile Security Group (MobSec):\n  • Ruhr-Universität Bochum\n  • Universitätsstraße 150\n  • 44801 Bochum\n  • E-Mail-Adresse: mobsec-studies@rub.de\n\nWeitere Kontaktdaten finden Sie in unserem Impressum.\n\n\n2   Datenverarbeitung\n\n2.1. Zugriffsdaten\nBeim anmelden, registrieren oder der Teilnahme an Studien in dieser App werden automatisch Daten und Informationen erfasst, die von Ihrem Endgerät an unseren Server übermittelt werden. Gleichzeitig werden Daten vom Server an die App übermittelt. **Hierbei** handelt es sich um folgende Informationen:\n  • Datum und Uhrzeit des Zugriffs\n  • IP-Adresse des Nutzers\n\nDiese Daten werden ausschließlich zur Sicherstellung eines störungsfreien Betriebs der App ausgewertet und anschließend gelöscht.\n\n2.2. Datenverarbeitung\nUnsere HCS Studies App speichert eingegebene Nutzerdaten in einer Google Firestore-Datenbank. Es werden dabei keine personenbezogenen Daten erfasst. Zu den gespeicherten Daten zählen alle vom Nutzer eingebenen Umfragedaten.\nDiese Daten werden ausschließlich zur Durchführung der Studien verwendet. Ihre Antworten im Rahmen dieser Studie werden mit Ihrer Qualtrics-ID verknüpft und in pseudonymisierter Form gespeichert. Wir erfragen keine Informationen, die Sie persönlich identifizieren könnten. Die Daten werden im Auftrag der Ruhr-Universität Bochum erhoben, eine Weitergabe an Dritte findet nicht statt. Durch Teilnahme an einer Studie stimmen Sie der Datenerhebung für den Zweck der Durchführung dieser Studie zu. Die Verarbeitung Ihrer personenbezogenen Daten erfolgt auf Grundlage von Art. 6 (1) a DSGVO und § 17 DSG NRW.\n\n2.3. Kontaktaufnahme\nWenn Sie uns per E-Mail kontaktieren, werden die von Ihnen gemachten Angaben zur Bearbeitung Ihrer Anfrage sowie für den Fall von Anschlussfragen bei uns gespeichert. Diese Daten geben wir nicht ohne Ihre Einwilligung weiter.\n\nDatensicherheit\nWir haben geeignete technische und organisatorische Maßnahmen ergriffen, um Ihre Daten vor Verlust, Zerstörung, Manipulation und unberechtigtem Zugriff zu schützen. Unsere Sicherheitsmaßnahmen werden entsprechend der technologischen Entwicklung fortlaufend verbessert.\n\nIhre Rechte\nSie haben das Recht, Ihre Einwilligung in die Datenverarbeitung jederzeit zu widerrufen, sowie Auskunft, Korrektur, Beschränkung der Verarbeitung sowie Löschung der über Sie gespeicherten Daten zu verlangen. Um diese Rechte wahrzunehmen, kontaktieren Sie bitte die folgende E-Mail-Adresse: mobsec-studies@rub.de. Die zuständige Aufsichtsbehörde ist die Landesdatenschutzbeauftragte des Landes Nordrhein-Westfalen."
        
        
        
        
        
        
        // Setze die Schriftart und die Schriftgröße des Labels
        //dataProtectionDetailsLabel.font = UIFont.systemFont(ofSize: 12)

        // Ändere die Schriftgröße des Labels auf 20
        //dataProtectionDetailsLabel.font = UIFont.systemFont(ofSize: 22)
        
        
        
        // Füge einen Aktionshandler hinzu, um die Schriftgröße des Labels zu ändern
        textFontSizeSlider.addTarget(self, action: #selector(sliderValueChanged(_:)), for: .valueChanged)

        // Setze die Constraints des StackView und des Labels
        /*
        dataProtectionDetailsLabel.translatesAutoresizingMaskIntoConstraints = false
        NSLayoutConstraint.activate([
            dataProtectionDetailsLabel.centerXAnchor.constraint(equalTo: view.centerXAnchor),
            dataProtectionDetailsLabel.centerYAnchor.constraint(equalTo: view.centerYAnchor)
        ])
        */
        
        //print(dataProtectionDetailsLabel.layer.position.x)
        //print(dataProtectionDetailsLabel.layer.position.y)
    }
    
    func openUrl(urlStr: String!) {
        if let url = URL(string:urlStr), !url.absoluteString.isEmpty {
            UIApplication.shared.open(url, options: [:], completionHandler: nil)
        }
    }
    
    // Methode zur Änderung der Schriftgröße
    @objc func sliderValueChanged(_ sender: UISlider) {
        
        //dataProtectionView.translatesAutoresizingMaskIntoConstraints = false
        //dataProtectionView.heightAnchor.constraint(equalToConstant: 150000).isActive = true
        
        /*
        // set view height constraint programmatically
        if(CGFloat(sender.value) == 0.5) {
            dataProtectionView.heightAnchor.constraint(equalToConstant: 6000).isActive = true
        } else if (CGFloat(sender.value) > 0.5 && CGFloat(sender.value)  <= 0.6) {
            dataProtectionView.heightAnchor.constraint(equalToConstant: 8500).isActive = true
        } else if (CGFloat(sender.value) > 0.6 && CGFloat(sender.value)  <= 0.7) {
            dataProtectionView.heightAnchor.constraint(equalToConstant: 12000).isActive = true
        } else if (CGFloat(sender.value) > 0.7 && CGFloat(sender.value)  <= 0.8) {
            dataProtectionView.heightAnchor.constraint(equalToConstant: 14000).isActive = true
        } else if (CGFloat(sender.value) > 0.8 && CGFloat(sender.value)  <= 0.9) {
            dataProtectionView.heightAnchor.constraint(equalToConstant: 17000).isActive = true
        } else if (CGFloat(sender.value) > 0.9 && CGFloat(sender.value)  <= 1.0) {
            dataProtectionView.heightAnchor.constraint(equalToConstant: 40000).isActive = true
        } else {
            dataProtectionView.heightAnchor.constraint(equalToConstant: 40000).isActive = true
        }
         */
         
        // Setze die neue Schriftgröße des Labels
        //dataProtectionDetailsLabel.font = UIFont.systemFont(ofSize: CGFloat(sender.value))
        
        // Berechne die neue Schriftgröße basierend auf dem Slider-Wert
        let fontSize = CGFloat(sender.value)
        print("Font Size:")
        print(fontSize)
        // Aktualisiere die Schriftgröße des Labels
        dataProtectionDetailsLabel.font = UIFont.systemFont(ofSize: fontSize*20) // *25
        
        // Rufe die setNeedsLayout()- und layoutIfNeeded()-Methoden des Labels auf, um sicherzustellen, dass es neu gezeichnet wird
        dataProtectionDetailsLabel.setNeedsLayout()
        dataProtectionDetailsLabel.layoutIfNeeded()
        
        
        dataProtectionHeaderLabel.font = UIFont.boldSystemFont(ofSize: fontSize*20+2)
        //dataProtectionHeaderLabel.font = UIFont.systemFont(ofSize: fontSize*20+2)
        dataProtectionHeaderLabel.setNeedsLayout()
        dataProtectionHeaderLabel.layoutIfNeeded()
        
        
        IntroductionAndOverviewHeaderLabel.font = UIFont.boldSystemFont(ofSize: fontSize*20+1)
        IntroductionAndOverviewHeaderLabel.setNeedsLayout()
        IntroductionAndOverviewHeaderLabel.layoutIfNeeded()
        
        
        var fontArrayIntroductionAndOverviewLabel = [UIFont]()
        fontArrayIntroductionAndOverviewLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.lightFontWithSize(size: fontSize*20))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArrayIntroductionAndOverviewLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.IntroductionAndOverviewLabel.attributedText = getAttributedString(arrayText: textArrayIntroductionAndOverviewLabel, arrayColors: colorArrayIntroductionAndOverviewLabel, arrayFonts: fontArrayIntroductionAndOverviewLabel)
        self.IntroductionAndOverviewLabel.isUserInteractionEnabled = true
        let tapgesture = UITapGestureRecognizer(target: self, action: #selector(tappedOnLabel(_ :)))
        tapgesture.numberOfTapsRequired = 1
        self.IntroductionAndOverviewLabel.addGestureRecognizer(tapgesture)
        IntroductionAndOverviewLabel.setNeedsLayout()
        IntroductionAndOverviewLabel.layoutIfNeeded()
        
        
        ApplicationAreaHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        ApplicationAreaHeaderLabel.setNeedsLayout()
        ApplicationAreaHeaderLabel.layoutIfNeeded()
        
        var fontArrayApplicationAreaDetailsLabel = [UIFont]()
        fontArrayApplicationAreaDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArrayApplicationAreaDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArrayApplicationAreaDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        self.ApplicationAreaDetailsLabel.attributedText = getAttributedString(arrayText: textArrayApplicationAreaDetailsLabel, arrayColors: colorArrayApplicationAreaDetailsLabel, arrayFonts: fontArrayApplicationAreaDetailsLabel)
        ApplicationAreaDetailsLabel.setNeedsLayout()
        ApplicationAreaDetailsLabel.layoutIfNeeded()
        
        
        /*Legal Bases*/
        legalBasesHeaderLabel.font = UIFont.boldSystemFont(ofSize: fontSize*20+1)
        legalBasesHeaderLabel.setNeedsLayout()
        legalBasesHeaderLabel.layoutIfNeeded()
        
        var fontArray_legalBasesDetailsLabel = [UIFont]()
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.lightFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_legalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.legalBasesDetailsLabel.attributedText = getAttributedString(arrayText: textArray_legalBasesDetailsLabel, arrayColors: colorArray_legalBasesDetailsLabel, arrayFonts: fontArray_legalBasesDetailsLabel)
        self.legalBasesDetailsLabel.isUserInteractionEnabled = true
        let tapgesture_LegalBases = UITapGestureRecognizer(target: self, action: #selector(tappedOnLabel_LegalBases(_ :)))
        tapgesture_LegalBases.numberOfTapsRequired = 1
        self.legalBasesDetailsLabel.addGestureRecognizer(tapgesture_LegalBases)
        legalBasesDetailsLabel.setNeedsLayout()
        legalBasesDetailsLabel.layoutIfNeeded()
        
        
        /*Contact Details*/
        contactDetailsHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        contactDetailsHeaderLabel.setNeedsLayout()
        contactDetailsHeaderLabel.layoutIfNeeded()
        
        var fontArray_contactDetailsDetailsLabel = [UIFont]()
        fontArray_contactDetailsDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.contactDetailsDetailsLabel.attributedText = getAttributedString(arrayText: textArray_contactDetailsDetailsLabel, arrayColors: colorArray_contactDetailsDetailsLabel, arrayFonts: fontArray_contactDetailsDetailsLabel)
        contactDetailsDetailsLabel.setNeedsLayout()
        contactDetailsDetailsLabel.layoutIfNeeded()
        
        
        /*Data Storage*/
        dataStorageHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        dataStorageHeaderLabel.setNeedsLayout()
        dataStorageHeaderLabel.layoutIfNeeded()
        

        var fontArray_dataStorageDetailsLabel = [UIFont]()
        fontArray_dataStorageDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.dataStorageDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataStorageDetailsLabel, arrayColors: colorArray_dataStorageDetailsLabel, arrayFonts: fontArray_dataStorageDetailsLabel)
        dataStorageDetailsLabel.setNeedsLayout()
        dataStorageDetailsLabel.layoutIfNeeded()
        
        
        /*Rights DSGVO*/
        rightsDSGVOHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        rightsDSGVOHeaderLabel.setNeedsLayout()
        rightsDSGVOHeaderLabel.layoutIfNeeded()
        
        var fontArray_rightsDSGVODetailsLabel = [UIFont]()
        fontArray_rightsDSGVODetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_rightsDSGVODetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_rightsDSGVODetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_rightsDSGVODetailsLabel.append(Fonts.lightFontWithSize(size: fontSize*20))
        fontArray_rightsDSGVODetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.rightsDSGVODetailsLabel.attributedText = getAttributedString(arrayText: textArray_rightsDSGVODetailsLabel, arrayColors: colorArray_rightsDSGVODetailsLabel, arrayFonts: fontArray_rightsDSGVODetailsLabel)
        self.rightsDSGVODetailsLabel.isUserInteractionEnabled = true
        let tapgesture_rightsDSGVO = UITapGestureRecognizer(target: self, action: #selector(tappedOnLabel_RightsDSGVO(_ :)))
        tapgesture_rightsDSGVO.numberOfTapsRequired = 1
        self.rightsDSGVODetailsLabel.addGestureRecognizer(tapgesture_rightsDSGVO)
        rightsDSGVODetailsLabel.setNeedsLayout()
        rightsDSGVODetailsLabel.layoutIfNeeded()
        
        
        /*North Rhine-Westphalia Data Protection Authority*/
        dataProtectionContactHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        dataProtectionContactHeaderLabel.setNeedsLayout()
        dataProtectionContactHeaderLabel.layoutIfNeeded()
        
        var fontArray_dataProtectionContactDetailsLabel = [UIFont]()
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.lightFontWithSize(size: fontSize*20))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_dataProtectionContactDetailsLabel.append(Fonts.lightFontWithSize(size: fontSize*20))
        
        self.dataProtectionContactDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataProtectionContactDetailsLabel, arrayColors: colorArray_dataProtectionContactDetailsLabel, arrayFonts: fontArray_dataProtectionContactDetailsLabel)
        self.dataProtectionContactDetailsLabel.isUserInteractionEnabled = true
        let tapgesture_dataProtectionContactDetails = UITapGestureRecognizer(target: self, action: #selector(tappedOnLabel_DataProtectionContactDetails(_ :)))
        tapgesture_dataProtectionContactDetails.numberOfTapsRequired = 1
        self.dataProtectionContactDetailsLabel.addGestureRecognizer(tapgesture_dataProtectionContactDetails)
        dataProtectionContactDetailsLabel.setNeedsLayout()
        dataProtectionContactDetailsLabel.layoutIfNeeded()
        
        
        /*Customer Data*/
        customerDataHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        customerDataHeaderLabel.setNeedsLayout()
        customerDataHeaderLabel.layoutIfNeeded()
        
        var fontArray_customerDataDetailsLabel = [UIFont]()
        fontArray_customerDataDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_customerDataDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.customerDataDetailsLabel.attributedText = getAttributedString(arrayText: textArray_customerDataDetailsLabel, arrayColors: colorArray_customerDataDetailsLabel, arrayFonts: fontArray_customerDataDetailsLabel)
        customerDataDetailsLabel.setNeedsLayout()
        customerDataDetailsLabel.layoutIfNeeded()
        
        
        /*What Customer Data?*/
        customerDataWhatHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        customerDataWhatHeaderLabel.setNeedsLayout()
        customerDataWhatHeaderLabel.layoutIfNeeded()
        
        var fontArray_customerDataWhatDetailsLabel = [UIFont]()
        fontArray_customerDataWhatDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        colorArray_customerDataWhatDetailsLabel.append(Colors.greyColor)
        
        self.customerDataWhatDetailsLabel.attributedText = getAttributedString(arrayText: textArray_customerDataWhatDetailsLabel, arrayColors: colorArray_customerDataWhatDetailsLabel, arrayFonts: fontArray_customerDataWhatDetailsLabel)
        customerDataWhatHeaderLabel.setNeedsLayout()
        customerDataWhatHeaderLabel.layoutIfNeeded()
        
        
        /*What Customer Data?*/
        customerDataWhyHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        customerDataWhyHeaderLabel.setNeedsLayout()
        customerDataWhyHeaderLabel.layoutIfNeeded()
        
        var fontArray_customerDataWhyDetailsLabel = [UIFont]()
        fontArray_customerDataWhyDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        colorArray_customerDataWhyDetailsLabel.append(Colors.greyColor)
        
        self.customerDataWhyDetailsLabel.attributedText = getAttributedString(arrayText: textArray_customerDataWhyDetailsLabel, arrayColors: colorArray_customerDataWhyDetailsLabel, arrayFonts: fontArray_customerDataWhyDetailsLabel)
        customerDataWhyHeaderLabel.setNeedsLayout()
        customerDataWhyHeaderLabel.layoutIfNeeded()
        
        
        /*Processed Data*/
        processedDataHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        processedDataHeaderLabel.setNeedsLayout()
        processedDataHeaderLabel.layoutIfNeeded()
        
        var fontArray_processedDataDetailsLabel = [UIFont]()
        fontArray_processedDataDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.processedDataDetailsLabel.attributedText = getAttributedString(arrayText: textArray_processedDataDetailsLabel, arrayColors: colorArray_processedDataDetailsLabel, arrayFonts: fontArray_processedDataDetailsLabel)
        processedDataDetailsLabel.setNeedsLayout()
        processedDataDetailsLabel.layoutIfNeeded()
        
        
        /*Data Location*/
        dataLocationHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        dataLocationHeaderLabel.setNeedsLayout()
        dataLocationHeaderLabel.layoutIfNeeded()
        
        var fontArray_dataLocationDetailsLabel = [UIFont]()
        fontArray_dataLocationDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.dataLocationDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataLocationDetailsLabel, arrayColors: colorArray_dataLocationDetailsLabel, arrayFonts: fontArray_dataLocationDetailsLabel)
        dataLocationDetailsLabel.setNeedsLayout()
        dataLocationDetailsLabel.layoutIfNeeded()
        
        
        /*Data Storage Duration*/
        dataStorageDurationHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        dataStorageDurationHeaderLabel.setNeedsLayout()
        dataStorageDurationHeaderLabel.layoutIfNeeded()

        var fontArray_dataStorageDurationDetailsLabel = [UIFont]()
        fontArray_dataStorageDurationDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.dataStorageDurationDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataStorageDurationDetailsLabel, arrayColors: colorArray_dataStorageDurationDetailsLabel, arrayFonts: fontArray_dataStorageDurationDetailsLabel)
        dataStorageDurationDetailsLabel.setNeedsLayout()
        dataStorageDurationDetailsLabel.layoutIfNeeded()
        
        
        /*Data Legal Bases*/
        dataLegalBasesHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        dataLegalBasesHeaderLabel.setNeedsLayout()
        dataLegalBasesHeaderLabel.layoutIfNeeded()

        var fontArray_dataLegalBasesDetailsLabel = [UIFont]()
        fontArray_dataLegalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        
        self.dataLegalBasesDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataLegalBasesDetailsLabel, arrayColors: colorArray_dataLegalBasesDetailsLabel, arrayFonts: fontArray_dataLegalBasesDetailsLabel)
        dataLegalBasesDetailsLabel.setNeedsLayout()
        dataLegalBasesDetailsLabel.layoutIfNeeded()
        
        
        /*Registration*/
        registrationHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        registrationHeaderLabel.setNeedsLayout()
        registrationHeaderLabel.layoutIfNeeded()

        var fontArray_registrationDetailsLabel = [UIFont]()
        fontArray_registrationDetailsLabel.append(Fonts.heavyFontWithSize(size: fontSize*20))
        fontArray_registrationDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.registrationDetailsLabel.attributedText = getAttributedString(arrayText: textArray_registrationDetailsLabel, arrayColors: colorArray_registrationDetailsLabel, arrayFonts: fontArray_registrationDetailsLabel)
        registrationDetailsLabel.setNeedsLayout()
        registrationDetailsLabel.layoutIfNeeded()
        
        
        /*What is a Registration?*/
        registrationWhatHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        registrationWhatHeaderLabel.setNeedsLayout()
        registrationWhatHeaderLabel.layoutIfNeeded()

        var fontArray_registrationWhatDetailsLabel = [UIFont]()
        fontArray_registrationWhatDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.registrationWhatDetailsLabel.attributedText = getAttributedString(arrayText: textArray_registrationWhatDetailsLabel, arrayColors: colorArray_registrationWhatDetailsLabel, arrayFonts: fontArray_registrationWhatDetailsLabel)
        registrationWhatDetailsLabel.setNeedsLayout()
        registrationWhatDetailsLabel.layoutIfNeeded()
        
        
        /*Why Processing Data?*/
        dataProcessingWhyHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        dataProcessingWhyHeaderLabel.setNeedsLayout()
        dataProcessingWhyHeaderLabel.layoutIfNeeded()
        
        var fontArray_dataProcessingWhyDetailsLabel = [UIFont]()
        fontArray_dataProcessingWhyDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.dataProcessingWhyDetailsLabel.attributedText = getAttributedString(arrayText: textArray_dataProcessingWhyDetailsLabel, arrayColors: colorArray_dataProcessingWhyDetailsLabel, arrayFonts: fontArray_dataProcessingWhyDetailsLabel)
        dataProcessingWhyDetailsLabel.setNeedsLayout()
        dataProcessingWhyDetailsLabel.layoutIfNeeded()
        
        
        /*Storage Duration*/
        storageDurationHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        storageDurationHeaderLabel.setNeedsLayout()
        storageDurationHeaderLabel.layoutIfNeeded()

        var fontArray_storageDurationDetailsLabel = [UIFont]()
        fontArray_storageDurationDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.storageDurationDetailsLabel.attributedText = getAttributedString(arrayText: textArray_storageDurationDetailsLabel, arrayColors: colorArray_storageDurationDetailsLabel, arrayFonts: fontArray_storageDurationDetailsLabel)
        storageDurationDetailsLabel.setNeedsLayout()
        storageDurationDetailsLabel.layoutIfNeeded()
        
        
        /* Right of Objection*/
        rightofObjectionHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        rightofObjectionHeaderLabel.setNeedsLayout()
        rightofObjectionHeaderLabel.layoutIfNeeded()

        var fontArray_rightofObjectionDetailsLabel = [UIFont]()
        fontArray_rightofObjectionDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.rightofObjectionDetailsLabel.attributedText = getAttributedString(arrayText: textArray_rightofObjectionDetailsLabel, arrayColors: colorArray_rightofObjectionDetailsLabel, arrayFonts: fontArray_rightofObjectionDetailsLabel)
        rightofObjectionDetailsLabel.setNeedsLayout()
        rightofObjectionDetailsLabel.layoutIfNeeded()
        
        
        /*Legal Bases*/
        registrationLegalBasesHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        registrationLegalBasesHeaderLabel.setNeedsLayout()
        registrationLegalBasesHeaderLabel.layoutIfNeeded()
        
        var fontArray_registrationLegalBasesDetailsLabel = [UIFont]()
        fontArray_registrationLegalBasesDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.registrationLegalBasesDetailsLabel.attributedText = getAttributedString(arrayText: textArray_registrationLegalBasesDetailsLabel, arrayColors: colorArray_registrationLegalBasesDetailsLabel, arrayFonts: fontArray_registrationLegalBasesDetailsLabel)
        registrationLegalBasesDetailsLabel.setNeedsLayout()
        registrationLegalBasesDetailsLabel.layoutIfNeeded()
        
        
        /*Registration Pseudonym*/
        registrationPseudonymHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        registrationPseudonymHeaderLabel.setNeedsLayout()
        registrationPseudonymHeaderLabel.layoutIfNeeded()
        
        var fontArray_registrationPseudonymDetailsLabel = [UIFont]()
        fontArray_registrationPseudonymDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.registrationPseudonymDetailsLabel.attributedText = getAttributedString(arrayText: textArray_registrationPseudonymDetailsLabel, arrayColors: colorArray_registrationPseudonymDetailsLabel, arrayFonts: fontArray_registrationPseudonymDetailsLabel)
        registrationPseudonymDetailsLabel.setNeedsLayout()
        registrationPseudonymDetailsLabel.layoutIfNeeded()
        
        
        /*Storage IP Address*/
        storageIPAddressHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        storageIPAddressHeaderLabel.setNeedsLayout()
        storageIPAddressHeaderLabel.layoutIfNeeded()
    
        var fontArray_storageIPAddressDetailsLabel = [UIFont]()
        fontArray_storageIPAddressDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.storageIPAddressDetailsLabel.attributedText = getAttributedString(arrayText: textArray_storageIPAddressDetailsLabel, arrayColors: colorArray_storageIPAddressDetailsLabel, arrayFonts: fontArray_storageIPAddressDetailsLabel)
        storageIPAddressDetailsLabel.setNeedsLayout()
        storageIPAddressDetailsLabel.layoutIfNeeded()
        
        /*Final Words*/
        finalWordsHeaderLabel.font = Fonts.heavyFontWithSize(size: fontSize*20+1)
        finalWordsHeaderLabel.setNeedsLayout()
        finalWordsHeaderLabel.layoutIfNeeded()
        
        var fontArray_finalWordsDetailsLabel = [UIFont]()
        fontArray_finalWordsDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        fontArray_finalWordsDetailsLabel.append(Fonts.lightFontWithSize(size: fontSize*20))
        fontArray_finalWordsDetailsLabel.append(Fonts.mediumFontWithSize(size: fontSize*20))
        
        self.finalWordsDetailsLabel.attributedText = getAttributedString(arrayText: textArray_finalWordsDetailsLabel, arrayColors: colorArray_finalWordsDetailsLabel, arrayFonts: fontArray_finalWordsDetailsLabel)
        self.finalWordsDetailsLabel.isUserInteractionEnabled = true
        let tapgesture_tapgesture_finalWords = UITapGestureRecognizer(target: self, action: #selector(tappedOnLabel_finalWords(_ :)))
        tapgesture_tapgesture_finalWords.numberOfTapsRequired = 1
        self.finalWordsDetailsLabel.addGestureRecognizer(tapgesture_tapgesture_finalWords)
        finalWordsDetailsLabel.setNeedsLayout()
        finalWordsDetailsLabel.layoutIfNeeded()
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        print(dataProtectionDetailsLabel.layer.position.x)
        print(dataProtectionDetailsLabel.layer.position.y)
        
        finalLabel.isHidden = true
    }
    
    //MARK:- tappedOnLabel
    @objc func tappedOnLabel(_ gesture: UITapGestureRecognizer) {
        guard let text = self.IntroductionAndOverviewLabel.text else { return }
        //guard let text2 = self.legalBasesDetailsLabel.text else { return }
        let conditionsRange = (text as NSString).range(of: "Datenschutzgrundverordnung (EU) 2016/679")
        //let conditionsRange_legalBases = (text as NSString).range(of: "https://eur-lex.europa.eu/legal-content/DE/ALL/?uri=celex%3A32016R0679")
        if gesture.didTapAttributedTextInLabel(label: self.IntroductionAndOverviewLabel, inRange: conditionsRange) {
            print("user tapped on condition text")
            
            openUrl(urlStr: "https://eur-lex.europa.eu/legal-content/DE/TXT/HTML/?uri=CELEX:32016R0679&from=DE&tid=322526481#d1e2269-1-1")
            
        }
    }
    
    
    @objc func tappedOnLabel_LegalBases(_ gesture: UITapGestureRecognizer) {
        guard let text = self.legalBasesDetailsLabel.text else { return }
        let conditionsRange = (text as NSString).range(of: "https://eur-lex.europa.eu/legal-content/DE/ALL/?uri=celex%3A32016R0679")
        
        if gesture.didTapAttributedTextInLabel(label: self.legalBasesDetailsLabel, inRange: conditionsRange) {
            openUrl(urlStr: "https://eur-lex.europa.eu/legal-content/DE/ALL/?uri=celex%3A32016R0679")
        }
    }
     
    @objc func tappedOnLabel_RightsDSGVO(_ gesture: UITapGestureRecognizer) {
        guard let text = self.rightsDSGVODetailsLabel.text else { return }
        let conditionsRange = (text as NSString).range(of: "Bundesbauftragte für den Datenschutz und die Informationsfreiheit (BfDI)")
        
        if gesture.didTapAttributedTextInLabel(label: self.rightsDSGVODetailsLabel, inRange: conditionsRange) {
            openUrl(urlStr: "https://www.bfdi.bund.de/DE/Home/home_node.html")
        }
    }
    
    @objc func tappedOnLabel_DataProtectionContactDetails(_ gesture: UITapGestureRecognizer) {
        guard let text = self.dataProtectionContactDetailsLabel.text else { return }
        let conditionsRange = (text as NSString).range(of: "https://www.ldi.nrw.de/")
        
        if gesture.didTapAttributedTextInLabel(label: self.dataProtectionContactDetailsLabel, inRange: conditionsRange) {
            openUrl(urlStr: "https://www.ldi.nrw.de/")
        }
    }
    
    @objc func tappedOnLabel_finalWords(_ gesture: UITapGestureRecognizer) {
        guard let text = self.finalWordsDetailsLabel.text else { return }
        let conditionsRange = (text as NSString).range(of: "Datenschutz Generator")
        
        if gesture.didTapAttributedTextInLabel(label: self.finalWordsDetailsLabel, inRange: conditionsRange) {
            openUrl(urlStr: "https://www.adsimple.de/datenschutz-generator/")
        }
    }
    

    //MARK:- getAttributedString
    func getAttributedString(arrayText:[String]?, arrayColors:[UIColor]?, arrayFonts:[UIFont]?) -> NSMutableAttributedString {
        
        
        
        let finalAttributedString = NSMutableAttributedString()
        
        for i in 0 ..< (arrayText?.count)! {
            
            var attributes = [NSAttributedString.Key.foregroundColor: arrayColors?[i], NSAttributedString.Key.font: arrayFonts?[i]]
            let attributedStr = (NSAttributedString.init(string: arrayText?[i] ?? "", attributes: attributes as [NSAttributedString.Key : Any]))
            
            if i != 0 {
                
                finalAttributedString.append(NSAttributedString.init(string: " "))
            }
            
            finalAttributedString.append(attributedStr)
        }
        
        return finalAttributedString
    }


struct Colors {
    
    static let carmine = UIColor.init(red: 169.0/255.0, green: 1.0/255.0, blue: 25.0/255.0, alpha: 1.0)
    
    static let greyColor = UIColor.init(red: 108.0/255.0, green: 108.0/255.0, blue: 108.0/255.0, alpha: 1.0)
    
    static let black = UIColor.init(red: 0/255.0, green: 0/255.0, blue: 0/255.0, alpha: 1.0)
}
struct Fonts {
    
    static func heavyFontWithSize(size: CGFloat) -> UIFont {
        return UIFont(name:"Avenir-Heavy", size: size)!
    }
    
    static func mediumFontWithSize(size: CGFloat) -> UIFont {
        return UIFont(name:"Avenir-Medium", size: size)!
    }
    
    static func lightFontWithSize(size: CGFloat) -> UIFont {
        return UIFont(name:"Avenir-Light", size: size)!
    }
}

    
    // set background color with gradient
    // https://stackoverflow.com/questions/24380535/how-to-apply-gradient-to-background-view-of-ios-swift-app
    func setGradientBackground() {
        let colorTop =  UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0).cgColor
        let  colorBottom = UIColor(red: 67.0/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0).cgColor
                    
        let gradientLayer = CAGradientLayer()
        gradientLayer.colors = [colorTop, colorBottom]
        gradientLayer.locations = [0.0, 1.0]
        gradientLayer.frame = self.view.bounds
                
        self.view.layer.insertSublayer(gradientLayer, at:0)
    }
    
    @IBAction func backButton(_ sender: Any) {
            
        /*
        let appDelegate = UIApplication.shared.delegate as! AppDelegate

        if(!appDelegate.hasAlreadyLaunched){
            let storyBoard: UIStoryboard = UIStoryboard(name: "Main", bundle: nil)
            let vc = storyBoard.instantiateViewController(withIdentifier: "LicenseAgreementVC") as! LicenseAgreementViewController
            self.view.window?.rootViewController = vc
            self.view.window?.makeKeyAndVisible()
            
        }
        */
        let defaults = UserDefaults.standard
        
        if(defaults.object(forKey: "showLicenseAgreement_v0") != nil)
        {
            showLicenseAgreementPublic = defaults.bool(forKey: "showLicenseAgreement_v0")
            if(showLicenseAgreementPublic) {
                let storyBoard: UIStoryboard = UIStoryboard(name: "Main", bundle: nil)
                let vc = storyBoard.instantiateViewController(withIdentifier: "LicenseAgreementVC") as! LicenseAgreementViewController
                self.view.window?.rootViewController = vc
                self.view.window?.makeKeyAndVisible()
            } else if(dataProtectionCalledFromHomeVCPublic) {
                let storyboard = UIStoryboard(name: "Main", bundle: nil)
                let tabBarController = storyboard.instantiateViewController(withIdentifier: "InitialTBC") as! UITabBarController
                
                self.view.window?.rootViewController = tabBarController
                self.view.window?.makeKeyAndVisible()
            } else {
                let vc = self.storyboard?.instantiateViewController(withIdentifier: "TEST55")
                
                let layout = UICollectionViewFlowLayout()
                self.view.window?.rootViewController = AuthenticationScreenViewController(collectionViewLayout: layout)
                
                self.view.window?.rootViewController = vc
                self.view.window?.makeKeyAndVisible()
            }
            
        } else {
            if(dataProtectionCalledFromHomeVCPublic) {
                let storyboard = UIStoryboard(name: "Main", bundle: nil)
                let tabBarController = storyboard.instantiateViewController(withIdentifier: "InitialTBC") as! UITabBarController
                
                self.view.window?.rootViewController = tabBarController
                self.view.window?.makeKeyAndVisible()
            } else {
                let vc = self.storyboard?.instantiateViewController(withIdentifier: "TEST55")
                
                let layout = UICollectionViewFlowLayout()
                self.view.window?.rootViewController = AuthenticationScreenViewController(collectionViewLayout: layout)
                
                self.view.window?.rootViewController = vc
                self.view.window?.makeKeyAndVisible()
            }

        }
    }
}

extension UIScrollView {

    func resizeScrollViewContentSize() {

        var contentRect = CGRect.zero

        for view in self.subviews {

            contentRect = contentRect.union(view.frame)

        }

        self.contentSize = contentRect.size

    }

}
